/*
 * SearchWindow.java
 *
 * Created on 2010-03-22, 16:39:05
 *
 * Author: Sebastian Sieczko
 */
package JDiskCat;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
 *
 * @author sebe
 */
public class SearchWindow extends javax.swing.JFrame {

    private String selected; //wybrany dysk
    private DefaultTableModel tableModel;
    private Vector columns;
    private Vector data;
    private DocumentBuilder loader;
    private Document document;
    private Node root; //węzeł główny
    private String pattern; //szukana fraza
    private Boolean allDisks = false; //czy przeszukiwać wszystkie dyski
    private Vector diskList; //lista dysków
    private String sizeRestrictMode = "Any";
    private String dateRestrictMode = "Any";
    private long size1 = 0, size2 = 0;
    private Date sqlDate1, sqlDate2;

    public SearchWindow() {
        initComponents();
        columns = new Vector(3);
        columns.add("Name");
        columns.add("Size");
        columns.add("Date");
        columns.add("Volume");
        columns.add("Location");
        tableModel = new DefaultTableModel();
        jTable1.setModel(tableModel);
        buttonGroup1.add(jRadioButton1);
        buttonGroup1.add(jRadioButton2);
        diskList = new Vector();
        refreshDiskList();

        // pobranie rozmiarow aplikacji
        Dimension dialogSize = getSize();
        // pobranie rozdzielczosci pulpitu
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (dialogSize.height > screenSize.height) {
            dialogSize.height = screenSize.height;
        }
        if (dialogSize.width > screenSize.width) {
            dialogSize.height = screenSize.width;
        }

        // rozmieszczenie aplikacji na srodku ekranu
        setLocation((screenSize.width - dialogSize.width) / 2,
                (screenSize.height - dialogSize.height) / 2);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jPopupMenu1 = new javax.swing.JPopupMenu();
        jMenuItem1 = new javax.swing.JMenuItem();
        jMenuItem2 = new javax.swing.JMenuItem();
        jButton1 = new javax.swing.JButton();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jButton2 = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();
        jTextField1 = new javax.swing.JTextField();
        jPanel2 = new javax.swing.JPanel();
        jRadioButton1 = new javax.swing.JRadioButton();
        jRadioButton2 = new javax.swing.JRadioButton();
        jComboBox1 = new javax.swing.JComboBox();
        jPanel3 = new javax.swing.JPanel();
        jComboBox2 = new javax.swing.JComboBox();
        jTextField2 = new javax.swing.JTextField();
        jComboBox4 = new javax.swing.JComboBox();
        jTextField3 = new javax.swing.JTextField();
        jComboBox5 = new javax.swing.JComboBox();
        jPanel4 = new javax.swing.JPanel();
        jSpinner2 = new javax.swing.JSpinner();
        jSpinner1 = new javax.swing.JSpinner();
        jComboBox3 = new javax.swing.JComboBox();

        jPopupMenu1.setEnabled(false);

        jMenuItem1.setText("Open");
        jMenuItem1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jMenuItem1MouseReleased(evt);
            }
        });
        jPopupMenu1.add(jMenuItem1);

        jMenuItem2.setText("Open containing folder");
        jMenuItem2.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jMenuItem2MouseReleased(evt);
            }
        });
        jPopupMenu1.add(jMenuItem2);

        setTitle("Search");

        jButton1.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jButton1.setText("Search");
        jButton1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jButton1MouseReleased(evt);
            }
        });
        jButton1.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                jButton1KeyReleased(evt);
            }
        });

        jScrollPane2.setAutoscrolls(true);
        jScrollPane2.setDoubleBuffered(true);

        jTable1.setAutoCreateRowSorter(true);
        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null}
            },
            new String [] {
                "Name", "Size", "Date"
            }
        ));
        jTable1.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_NEXT_COLUMN);
        jTable1.setComponentPopupMenu(jPopupMenu1);
        jTable1.setDoubleBuffered(true);
        jTable1.setEditingColumn(0);
        jTable1.setEditingRow(0);
        jTable1.setFillsViewportHeight(true);
        jTable1.setFocusable(false);
        jTable1.setGridColor(new java.awt.Color(255, 255, 255));
        jTable1.setIntercellSpacing(new java.awt.Dimension(0, 0));
        jTable1.setShowHorizontalLines(false);
        jTable1.setShowVerticalLines(false);
        jTable1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                jTable1MousePressed(evt);
            }
        });
        jScrollPane2.setViewportView(jTable1);

        jButton2.setText("Close");
        jButton2.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jButton2MouseReleased(evt);
            }
        });
        jButton2.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                jButton2KeyReleased(evt);
            }
        });

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Phrase"));

        jTextField1.setToolTipText("<html>Search phrase should be at least 2 characters long. Case is ignored. You may leave this field empty if you want to search by size or date.<br>Literal search (using quotes): \"search phrase\"<br>Search using keywords (separated by spaces): keyword1 keyword2</html>");
        jTextField1.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                jTextField1KeyReleased(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jTextField1)
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addComponent(jTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Search locations"));

        jRadioButton1.setSelected(true);
        jRadioButton1.setText("Volume");
        jRadioButton1.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jRadioButton1StateChanged(evt);
            }
        });

        jRadioButton2.setText("All volumes");

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jRadioButton2, javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jRadioButton1)
                        .addGap(3, 3, 3)
                        .addComponent(jComboBox1, javax.swing.GroupLayout.PREFERRED_SIZE, 140, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jRadioButton1)
                    .addComponent(jComboBox1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jRadioButton2))
        );

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("Size"));

        jComboBox2.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Any", "<", "<=", "=", ">=", ">", "Between" }));
        jComboBox2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox2ActionPerformed(evt);
            }
        });

        jTextField2.setEditable(false);
        jTextField2.setPreferredSize(new java.awt.Dimension(50, 19));

        jComboBox4.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "B", "kB", "MB", "GB" }));
        jComboBox4.setEnabled(false);

        jTextField3.setEditable(false);
        jTextField3.setPreferredSize(new java.awt.Dimension(50, 19));

        jComboBox5.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "B", "kB", "MB", "GB" }));
        jComboBox5.setEnabled(false);

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jComboBox2, javax.swing.GroupLayout.PREFERRED_SIZE, 75, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTextField2, javax.swing.GroupLayout.PREFERRED_SIZE, 50, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jComboBox4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jTextField3, javax.swing.GroupLayout.PREFERRED_SIZE, 50, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jComboBox5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                .addComponent(jComboBox2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addComponent(jTextField2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addComponent(jComboBox4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addComponent(jTextField3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addComponent(jComboBox5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder("Date"));

        jSpinner2.setModel(new javax.swing.SpinnerDateModel());
        jSpinner2.setToolTipText("Date in DD-MM-YY HH-MM format");
        jSpinner2.setEnabled(false);

        jSpinner1.setModel(new javax.swing.SpinnerDateModel());
        jSpinner1.setToolTipText("Date in DD-MM-YY HH-MM format");
        jSpinner1.setEnabled(false);

        jComboBox3.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Any", "<", "<=", "=", ">=", ">", "Between" }));
        jComboBox3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox3ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jComboBox3, javax.swing.GroupLayout.PREFERRED_SIZE, 75, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSpinner1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(jSpinner2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                .addComponent(jComboBox3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addComponent(jSpinner2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addComponent(jSpinner1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane2)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jPanel4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 27, Short.MAX_VALUE)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jButton1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 100, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jButton2, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 100, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jButton1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jButton2))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jPanel4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 386, Short.MAX_VALUE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jTextField1KeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jTextField1KeyReleased
        if (evt.getKeyCode() == KeyEvent.VK_ENTER) {
            prepareSearch();
        }
    }//GEN-LAST:event_jTextField1KeyReleased

    private void jButton2MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton2MouseReleased
        this.setVisible(false);
    }//GEN-LAST:event_jButton2MouseReleased

    private void jRadioButton1StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jRadioButton1StateChanged
        if (jRadioButton1.isSelected()) {
            allDisks = false;
            jComboBox1.setEnabled(true);
        } else {
            allDisks = true;
            jComboBox1.setEnabled(false);
        }
    }//GEN-LAST:event_jRadioButton1StateChanged

    private void jButton2KeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jButton2KeyReleased
        if (evt.getKeyCode() == KeyEvent.VK_ENTER) {
            this.setVisible(false);
        }
    }//GEN-LAST:event_jButton2KeyReleased

    private void jButton1KeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jButton1KeyReleased
        if (evt.getKeyCode() == KeyEvent.VK_ENTER) {
            prepareSearch();
        }
    }//GEN-LAST:event_jButton1KeyReleased

    private void jButton1MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton1MouseReleased
        prepareSearch();
    }//GEN-LAST:event_jButton1MouseReleased

    private void jMenuItem1MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jMenuItem1MouseReleased
        // Menu kontekstowe - otwórz w skojarz. aplikacji
        int row = jTable1.getSelectedRow();
        System.out.println(row);
        if (row != -1 && jTable1.getValueAt(row, 1).toString().length() > 1) {
            try {
                //path z xml np. C:\test zamiant selected w path + \ + nazwa pliku
                //lub path z xml np. C:\ zamiast (selected\) w path + \ +nazwa pliku
                document = loader.parse(jTable1.getValueAt(row, 3).toString() + ".xml");
                root = document.getLastChild();
                Element rootElement = (Element) root;
                String rootPath = rootElement.getAttribute("path");
                String filePath;
                String fileName = jTable1.getValueAt(row, 0).toString();
                String volumeName=jTable1.getValueAt(row, 3).toString();
                //int x1 = fileName.indexOf("[");
                //int x2 = fileName.lastIndexOf("]");
                //if (x1 != -1 && x2 != -1) {
                //    fileName = fileName.substring(x1 + 1, x2);
                //}
                if (rootPath.trim().length() == 3) {
                    filePath = (String) jTable1.getValueAt(row, 4);
                    filePath = rootPath + filePath.substring(1) + "\\" + fileName;
                } else {
                    filePath = (String) jTable1.getValueAt(row, 4);
                    if (filePath.equals("\\")) {
                        filePath = "";
                    }
                    filePath = rootPath + filePath + "\\" + fileName;
                }
                if (filePath.indexOf("/") != -1) {
                    filePath = filePath.replace('\\', '/');
                }
                System.out.println(filePath);
                File file = new File(filePath);
                if (file.exists()) {
                    Desktop desktop;
                    if (Desktop.isDesktopSupported()) {
                        desktop = Desktop.getDesktop();
                        try {
                            desktop.open(file);
                        } catch (IOException ex) {
                            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                            JOptionPane.showMessageDialog(this, "An error occurred while opening the file. Most likely, no application is associated with that file type.", "Error opening the file.", JOptionPane.ERROR_MESSAGE);
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "The requested item is not available. Check availability of the volume: \"" + volumeName + "\".", "Error", JOptionPane.ERROR_MESSAGE);
                }
            } catch (SAXException ex) {
                Logger.getLogger(SearchWindow.class.getName()).log(Level.SEVERE, null, ex);
            } catch (IOException ex) {
                Logger.getLogger(SearchWindow.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

    }//GEN-LAST:event_jMenuItem1MouseReleased

    private void jMenuItem2MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jMenuItem2MouseReleased
        // Menu kontekstowe - otwórz folder zawierający
        int row = jTable1.getSelectedRow();
        if (row != -1 && jTable1.getValueAt(row, 1).toString().length() > 1) {
            try {
                //path z xml np. C:\test zamiant selected w path + \ + nazwa pliku
                //lub path z xml np. C:\ zamiast (selected\) w path + \ +nazwa pliku
                document = loader.parse(jTable1.getValueAt(row, 3).toString() + ".xml");
                root = document.getLastChild();
                Element rootElement = (Element) root;
                String volumeName=jTable1.getValueAt(row, 3).toString();
                String rootPath = rootElement.getAttribute("path");
                String filePath;
                if (rootPath.trim().length() == 3) {
                    filePath = (String) jTable1.getValueAt(row, 4);
                    filePath = rootPath + filePath.substring(1);
                } else {
                    filePath = (String) jTable1.getValueAt(row, 4);
                    if (filePath.equals("\\")) {
                        filePath = "";
                    }
                    filePath = rootPath + filePath;
                }
                if (filePath.indexOf("/") != -1) {
                    filePath = filePath.replace('\\', '/');
                }
                System.out.println(filePath);
                File file = new File(filePath);
                if (file.exists()) {
                    Desktop desktop;
                    if (Desktop.isDesktopSupported()) {
                        desktop = Desktop.getDesktop();
                        try {
                            desktop.open(file);
                        } catch (IOException ex) {
                            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                            JOptionPane.showMessageDialog(this, "An error occurred while opening the folder.", "Error opening folder.", JOptionPane.ERROR_MESSAGE);
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "The requested folder is not available. Check availability of the volume: \"" + volumeName + "\".", "Error opening folder.", JOptionPane.ERROR_MESSAGE);
                }
            } catch (SAXException ex) {
                Logger.getLogger(SearchWindow.class.getName()).log(Level.SEVERE, null, ex);
            } catch (IOException ex) {
                Logger.getLogger(SearchWindow.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }//GEN-LAST:event_jMenuItem2MouseReleased

    private void jTable1MousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTable1MousePressed
        Point p = evt.getPoint();
        int row = jTable1.rowAtPoint(p);
        if (row != -1) {
            ListSelectionModel model = jTable1.getSelectionModel();
            model.setSelectionInterval(row, row);
            jTable1.setComponentPopupMenu(jPopupMenu1);
        } else {
            ListSelectionModel model = jTable1.getSelectionModel();
            model.clearSelection();
            jTable1.setComponentPopupMenu(null);
        }

    }//GEN-LAST:event_jTable1MousePressed

    private void jComboBox2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox2ActionPerformed
        //Size Restrict Mode
        sizeRestrictMode = jComboBox2.getSelectedItem().toString().trim();
        System.out.println(sizeRestrictMode);
        if (sizeRestrictMode.equals("Any")) {
            jTextField2.setEditable(false);
            jComboBox4.setEnabled(false);
            jTextField3.setEditable(false);
            jComboBox5.setEnabled(false);
        } else if (sizeRestrictMode.equals("Between")) {
            jTextField2.setEditable(true);
            jComboBox4.setEnabled(true);
            jTextField3.setEditable(true);
            jComboBox5.setEnabled(true);
        } else {
            jTextField2.setEditable(true);
            jComboBox4.setEnabled(true);
            jTextField3.setEditable(false);
            jComboBox5.setEnabled(false);
        }
    }//GEN-LAST:event_jComboBox2ActionPerformed

    private void jComboBox3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox3ActionPerformed
        //Date Restrict Mode
        dateRestrictMode = jComboBox3.getSelectedItem().toString().trim();
        System.out.println(dateRestrictMode);
        if (dateRestrictMode.equals("Any")) {
            //jTextField4.setEditable(false);
            //jTextField5.setEditable(false);
            jSpinner1.setEnabled(false);
            jSpinner2.setEnabled(false);
        } else if (dateRestrictMode.equals("Between")) {
            //jTextField4.setEditable(true);
            //jTextField5.setEditable(true);
            jSpinner1.setEnabled(true);
            jSpinner2.setEnabled(true);
        } else {
            //jTextField4.setEditable(true);
            //jTextField5.setEditable(false);
            jSpinner1.setEnabled(true);
            jSpinner2.setEnabled(false);
        }
    }//GEN-LAST:event_jComboBox3ActionPerformed

    private void readDisk(String filename) {
        try {
            document = loader.parse(filename);
            root = document.getLastChild();
            search(root, "\\");
        } catch (SAXException ex) {
            Logger.getLogger(SearchWindow.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(SearchWindow.class.getName()).log(Level.SEVERE, null, ex);
        }

    }

    private void search(Node dir, String path) {
        NodeList list = dir.getChildNodes();

        Vector row;
        row = new Vector(3);
        
        for (int i = 0; i < list.getLength(); i++) {
            Node node = list.item(i);

            if (node instanceof Element) {
                Element child = (Element) node;
                String attribName = child.getAttribute("name");
                String attribDate = child.getAttribute("date");
                String attribSize = child.getAttribute("size");
                String noQuotes;
                String[] patterns;

                Boolean itemFound = false;
                Boolean itemFoundByName = false;
                Boolean itemFoundBySize = false;
                Boolean itemFoundByDate = false;

                if (attribSize.isEmpty()) {
                    attribSize = "<DIR>";
                }
                //Searching by name only
                if (pattern.length() > 1 && sizeRestrictMode.equals("Any") && dateRestrictMode.equals("Any")) {
                    //Long itemSize = Long.parseLong(attribSize);
                    //System.out.println(itemSize);
                    //Date itemDate = toSqlDate(attribDate);
                    //System.out.println(itemDate);
                    if(pattern.startsWith("\"") && pattern.endsWith("\"")) {//literal search
                        //System.out.println(pattern.substring(1, pattern.length()-1));
                        noQuotes = pattern.substring(1, pattern.length()-1);
                        patterns = new String[1];
                        patterns[0]=noQuotes;
                    }
                    else {//split by spaces and search all substrings separately
                        patterns = pattern.split(" ");
                    }
                    itemFound = true;
                    for(int j=0;j<patterns.length;j++) {//all patterns must be found
                        if(attribName.toLowerCase().indexOf(patterns[j].toLowerCase()) == -1)
                            itemFound = false;
                    }
                }

                //Searching by size
                if (!sizeRestrictMode.equals("Any") && !attribSize.equals("<DIR>")) {
                    if (pattern.length() > 1) {
                        if(pattern.startsWith("\"") && pattern.endsWith("\"")) {//literal search
                            //System.out.println(pattern.substring(1, pattern.length()-1));
                            noQuotes = pattern.substring(1, pattern.length()-1);
                            patterns = new String[1];
                            patterns[0]=noQuotes;
                        }
                        else {//split by spaces and search all substrings separately
                            patterns = pattern.split(" ");
                        }
                        itemFoundByName = true;
                        for(int j=0;j<patterns.length;j++) {//all patterns must be found
                            if(attribName.toLowerCase().indexOf(patterns[j].toLowerCase()) == -1)
                                itemFoundByName = false;
                        }
                    }

                    Long itemSize = Long.parseLong(attribSize);
                    if (sizeRestrictMode.equals("<")) {

                        if (itemSize < size1) {
                            itemFoundBySize = true;
                        } else {
                            itemFoundBySize = false;
                        }
                    }
                    if (sizeRestrictMode.equals("<=")) {
                        if (itemSize <= size1) {
                            itemFoundBySize = true;
                        } else {
                            itemFoundBySize = false;
                        }
                    }
                    if (sizeRestrictMode.equals("=")) {
                        if (itemSize == size1) {
                            itemFoundBySize = true;
                        } else {
                            itemFoundBySize = false;
                        }
                    }
                    if (sizeRestrictMode.equals(">=")) {
                        if (itemSize >= size1) {
                            itemFoundBySize = true;
                        } else {
                            itemFoundBySize = false;
                        }
                    }
                    if (sizeRestrictMode.equals(">")) {
                        if (itemSize > size1) {
                            itemFoundBySize = true;
                        } else {
                            itemFoundBySize = false;
                        }
                    }
                    if (sizeRestrictMode.equals("Between")) {
                        if (itemSize >= size1 && itemSize <= size2) {
                            itemFoundBySize = true;
                        } else {
                            itemFoundBySize = false;
                        }
                    }
                }

                //Searching by date
                if (!dateRestrictMode.equals("Any")) {
                    if (pattern.length() > 1) {
                        if(pattern.startsWith("\"") && pattern.endsWith("\"")) {//literal search
                            //System.out.println(pattern.substring(1, pattern.length()-1));
                            noQuotes = pattern.substring(1, pattern.length()-1);
                            patterns = new String[1];
                            patterns[0]=noQuotes;
                        }
                        else {//split by spaces and search all substrings separately
                            patterns = pattern.split(" ");
                        }
                        itemFoundByName = true;
                        for(int j=0;j<patterns.length;j++) {//all patterns must be found
                            if(attribName.toLowerCase().indexOf(patterns[j].toLowerCase()) == -1)
                                itemFoundByName = false;
                        }
                    }

                    Date itemDate = toSqlDate(attribDate);
                    //System.out.println(itemDate);
                    if (dateRestrictMode.equals("<")) {
                        if (itemDate.compareTo(sqlDate1) < 0) {
                            itemFoundByDate = true;
                        } else {
                            itemFoundByDate = false;
                        }
                    }
                    if (dateRestrictMode.equals("<=")) {
                        if (itemDate.compareTo(sqlDate1) <= 0) {
                            itemFoundByDate = true;
                        } else {
                            itemFoundByDate = false;
                        }
                    }
                    if (dateRestrictMode.equals("=")) {
                        if (itemDate.compareTo(sqlDate1) == 0) {
                            itemFoundByDate = true;
                        } else {
                            itemFoundByDate = false;
                        }
                    }
                    if (dateRestrictMode.equals(">=")) {
                        if (itemDate.compareTo(sqlDate1) >= 0) {
                            itemFoundByDate = true;
                        } else {
                            itemFoundByDate = false;
                        }
                    }
                    if (dateRestrictMode.equals(">")) {
                        if (itemDate.compareTo(sqlDate1) > 0) {
                            itemFoundByDate = true;
                        } else {
                            itemFoundByDate = false;
                        }
                    }
                    if (dateRestrictMode.equals("Between")) {
                        if (itemDate.compareTo(sqlDate1) >= 0 && itemDate.compareTo(sqlDate2) <= 0) {
                            itemFoundByDate = true;
                        } else {
                            itemFoundByDate = false;
                        }
                    }

                }

                if (!sizeRestrictMode.equals("Any") && !dateRestrictMode.equals("Any")) {
                    if (pattern.length() > 1) {
                        if (itemFoundByName && itemFoundBySize && itemFoundByDate) {
                            itemFound = true;
                        }
                    } else {
                        if (itemFoundBySize && itemFoundByDate) {
                            itemFound = true;
                        }
                    }
                }

                if (!sizeRestrictMode.equals("Any") && dateRestrictMode.equals("Any")) {
                    if (pattern.length() > 1) {
                        if (itemFoundByName && itemFoundBySize) {
                            itemFound = true;
                        }
                    } else {
                        if (itemFoundBySize) {
                            itemFound = true;
                        }
                    }
                }

                if (sizeRestrictMode.equals("Any") && !dateRestrictMode.equals("Any")) {
                    if (pattern.length() > 1) {
                        if (itemFoundByName && itemFoundByDate) {
                            itemFound = true;
                        }
                    } else {
                        if (itemFoundByDate) {
                            itemFound = true;
                        }
                    }
                }

                if (itemFound) {//Add found item to data
                    row = new Vector(3);
                    if (!attribSize.equals("<DIR>")) {
                        long size = Long.parseLong(attribSize);
                        attribSize = Main.sizeFormat(size);
                    }
                    if (attribSize.equals("<DIR>")) {
                        row.add(attribName);
                    } else {
                        row.add(attribName);
                    }

                    row.add(attribSize);
                    row.add(attribDate);
                    row.add(selected);
                    row.add(path);
                    data.add(row);
                    //System.out.println(itemFound + " " + itemFoundByName + " " + itemFoundBySize + " " + itemFoundByDate + " " + size1 + " " + size2);
                    //if(!dateRestrictMode.equals("Any"))
                    //System.out.println(sqlDate1+" "+sqlDate2+" "+itemDate+" "+" "+itemDate.compareTo(sqlDate1)+" "+itemDate.compareTo(sqlDate2));
                }

                if (attribSize.equals("<DIR>")) {
                    if (path.equals("\\")) {
                        search(node, path + attribName);
                    } else {
                        search(node, path + "\\" + attribName);
                    }
                }
            }
        }

    }

    private void refreshDiskList() {
        jComboBox1.removeAllItems();
        /*
         * File dir = new File("."); //kat. programu
         *
         * FilenameFilter filter = new FilenameFilter() {
         *
         * public boolean accept(File dir, String name) { return
         * name.endsWith(".xml") || name.endsWith(".XML"); } };
         *
         * File[] chld = dir.listFiles(filter);
         *
         * if (chld == null) { System.out.println("The selected directory does
         * not exist or is not a directory."); } else { for (int i = 0; i <
         * chld.length; i++) { if (chld[i].isFile() &&
         * !chld[i].getName().equals("build.xml") && chld[i].length() > 0) {
         * String name = Main.getFileNameWithoutExtension(chld[i].getName());
         * jComboBox1.addItem(name); diskList.add(name); }
         *
         * }
         * }
         */
        for (int i = 0; i < Main.getDiskList().getSize(); i++) {
            String name = Main.getDiskList().getElementAt(i).toString();
            jComboBox1.addItem(name);
            diskList.add(name);
        }
        if (Main.getSelectedIndex() != -1) {
            for (int i = 0; i < jComboBox1.getItemCount(); i++) {
                if (jComboBox1.getItemAt(i).toString().equals(Main.getSelected())) {
                    jComboBox1.setSelectedIndex(i);
                }
            }
        }
    }

    private void prepareSearch() {
        selected = jComboBox1.getSelectedItem().toString();
        pattern = jTextField1.getText().trim();
        jTextField1.setText(pattern);
        Boolean ready = true;

        if (!sizeRestrictMode.equals("Any")) {
            try {
                size1 = Long.parseLong(jTextField2.getText().trim());
            } catch (Exception e) {
                jTextField2.setText("");

                ready = false;
                JOptionPane.showMessageDialog(this,
                        "Enter valid size value.",
                        "Size field 1",
                        JOptionPane.ERROR_MESSAGE);
            }

            if (jComboBox4.getSelectedItem().equals("kB")) {
                size1 = size1 * 1024;
            }
            if (jComboBox4.getSelectedItem().equals("MB")) {
                size1 = size1 * 1024 * 1024;
            }
            if (jComboBox4.getSelectedItem().equals("GB")) {
                size1 = size1 * 1024 * 1024 * 1024;
            }
            System.out.println(size1);
            if (sizeRestrictMode.equals("Between")) {
                try {
                    size2 = Long.parseLong(jTextField3.getText().trim());
                } catch (Exception e) {
                    jTextField3.setText("");

                    ready = false;
                    JOptionPane.showMessageDialog(this,
                            "Enter valid size value.",
                            "Size field 2",
                            JOptionPane.ERROR_MESSAGE);
                }
                if (jComboBox5.getSelectedItem().equals("kB")) {
                    size2 = size2 * 1024;
                }
                if (jComboBox5.getSelectedItem().equals("MB")) {
                    size2 = size2 * 1024 * 1024;
                }
                if (jComboBox5.getSelectedItem().equals("GB")) {
                    size2 = size2 * 1024 * 1024 * 1024;
                }
                System.out.println(size2);
            }
        }
        if (!dateRestrictMode.equals("Any")) {
            /*
             * date1 = jTextField4.getText().trim(); sqlDate1 =
             * toSqlDate(date1); if (sqlDate1 == null) {
             * jTextField4.setText("YYYY-MM-DD"); return; }
             * jTextField4.setText(sqlDate1.toString());//just in case user
             * entered something strange and conversion made a valid date of it
             * System.out.println(sqlDate1); if
             * (dateRestrictMode.equals("Between")) { date2 =
             * jTextField5.getText().trim(); sqlDate2 = toSqlDate(date2); if
             * (sqlDate2 == null) { jTextField5.setText("YYYY-MM-DD"); return; }
             * jTextField5.setText(sqlDate2.toString());
             * System.out.println(sqlDate2); }
             */
            java.util.Date Date1 = (java.util.Date) jSpinner1.getValue();
            System.out.println(Date1);
            sqlDate1 = new java.sql.Date(Date1.getTime());
            System.out.println(sqlDate1);

            java.util.Date Date2 = (java.util.Date) jSpinner2.getValue();
            System.out.println(Date2);
            sqlDate2 = new java.sql.Date(Date2.getTime());
            System.out.println(sqlDate2);
        }

        if (ready && selected != null && !selected.isEmpty() && (pattern.length() > 1 || !sizeRestrictMode.equals("Any") || !dateRestrictMode.equals("Any"))) {
            try {
                data = new Vector(3);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                loader = factory.newDocumentBuilder();
                if (!allDisks) {
                    readDisk(selected + ".xml");
                } else {
                    for (int i = 0; i < diskList.size(); i++) {
                        selected = diskList.get(i).toString();
                        readDisk(selected + ".xml");
                    }
                }
                if (!data.isEmpty()) {
                    tableModel = new javax.swing.table.DefaultTableModel(data, columns);
                    jTable1.setModel(tableModel);
                } else {
                    //JOptionPane.showMessageDialog(this,"No results.","Search",JOptionPane.INFORMATION_MESSAGE);
                    jTable1.setModel(new DefaultTableModel());
                }
            } catch (ParserConfigurationException ex) {
                Logger.getLogger(SearchWindow.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        /*
         * else{ Vector row; row = new Vector(3); row.add("Enter search phrase
         * or search by size or date"); data = new Vector(3); data.add(row);
         * tableModel = new javax.swing.table.DefaultTableModel(data, columns);
         * jTable1.setModel(tableModel); }
         */
    }

    public java.sql.Date toSqlDate(String strDate) {
        DateFormat dateFrm = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        java.util.Date myDate;// = new java.util.Date();
        java.sql.Date sqlDate;

        try {
            myDate = dateFrm.parse(strDate);
            //System.out.println(myDate);
            sqlDate = new java.sql.Date(myDate.getTime());
        } catch (Exception e) {
            sqlDate = null;
            System.out.println("String to Date conversion error.");
        }

        return (sqlDate);
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new SearchWindow().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JComboBox jComboBox1;
    private javax.swing.JComboBox jComboBox2;
    private javax.swing.JComboBox jComboBox3;
    private javax.swing.JComboBox jComboBox4;
    private javax.swing.JComboBox jComboBox5;
    private javax.swing.JMenuItem jMenuItem1;
    private javax.swing.JMenuItem jMenuItem2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPopupMenu jPopupMenu1;
    private javax.swing.JRadioButton jRadioButton1;
    private javax.swing.JRadioButton jRadioButton2;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JSpinner jSpinner1;
    private javax.swing.JSpinner jSpinner2;
    private static javax.swing.JTable jTable1;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JTextField jTextField2;
    private javax.swing.JTextField jTextField3;
    // End of variables declaration//GEN-END:variables
}
